package dao

import (
	"github.com/influxdata/influxdb/client/v2"
	"time"
)

type CachePoint struct {
	Name   string                 `json:"name"`
	Tags   map[string]string      `json:"tags"`
	Fields map[string]interface{} `json:"fields"`
	Time   time.Time              `json:"time"`
}

func NewPoint(point *client.Point) CachePoint {
	cp := CachePoint{}
	cp.Name = point.Name()
	cp.Time = point.Time()
	cp.Fields, _ = point.Fields()
	cp.Tags = point.Tags()
	return cp
}
