package dao

import (
	"fmt"
	"github.com/influxdata/influxdb/client/v2"
	"testing"
	"time"
)

func TestNew(t *testing.T) {
	d := New(1024, time.Second*60, "http://", ".")
	if d == nil {
		t.Error("d != nil")
	}
}

func TestDao_MsgProcess(t *testing.T) {
	d := New(1024, time.Second*5, "http://", ".")
	fmt.Println("111222")
	for i := 0; i < 11000; i++ {
		point, _ := client.NewPoint("123", map[string]string{"123": "123"}, map[string]interface{}{"123": "123"})
		d.MsgProcess(point)
	}
	fmt.Println("1111aaa")
	time.Sleep(time.Second * 10)

	for i := 0; i < 11000; i++ {
		point, _ := client.NewPoint("123", map[string]string{"123": "123"}, map[string]interface{}{"123": "123"})
		d.MsgProcess(point)
	}

	if d == nil {
		t.Error("d != nil")
	}
	select {}
}

func TestDao_MsgProcess2(t *testing.T) {
	d := New(1024, time.Second*5, "http://", "/Users/fengjunkai/llog")
	time.Sleep(time.Second * 4)
	fmt.Println("111222")
	for i := 0; i < 11000; i++ {
		point, _ := client.NewPoint("123", map[string]string{"123": "123"}, map[string]interface{}{"123": "123"})
		d.MsgProcess(point)
	}
	fmt.Println("1111aaa")

	for i := 0; i < 11000; i++ {
		point, _ := client.NewPoint("123", map[string]string{"123": "123"}, map[string]interface{}{"123": "123"})
		d.MsgProcess(point)
	}

	if d == nil {
		t.Error("d != nil")
	}
	select {}
}

func TestChannel(t *testing.T) {
	a := make(chan int, 10)

	go func() {
		defer func() {
			if e := recover(); e != nil {
				t.Log("平滑退出chan")
			}
		}()
		for {
			a <- 1
			fmt.Println("111")
			time.Sleep(time.Second)
		}
	}()

	time.Sleep(time.Second * 5)

	close(a)

	time.Sleep(time.Second * 5)

	for x := range a {
		fmt.Println("print a:", x)
	}
}
