package report_form

import (
	"testing"
	"time"
)

func TestNewServiceMap(t *testing.T) {
	sm := NewServiceMap(time.Now().Add(time.Hour*24*-1), time.Now())

	t.Log("访问量：", sm.GetCount())
	t.Log("总访问时间：", sm.GetSumDuration())
	t.Log("总平均访问时间：", sm.GetAverageDuration())
	t.Log("------------------median-------------------")
	medianList := sm.GetMedianDurationPathList()
	t.Log("服务数量：", len(medianList))
	for _, m := range medianList {
		t.Log(m.GetMedianDuration(), m.GetServiceName(), m.GetPath())
	}
	t.Log("------------------average------------------")
	averageList := sm.GetAverageDurationPathList()
	t.Log("服务数量：", len(averageList))
	for _, m := range averageList {
		t.Log(m.GetAverageDuration(), m.GetServiceName(), m.GetPath())
	}
	t.Log("------------------max----------------------")
	maxList := sm.GetMaxDurationTracePointList()
	t.Log("服务数量：", len(maxList))
	for _, m := range maxList {
		t.Log(m.Duration, m.ServiceName, m.Path, m.Timestamp, m.TraceId)
	}
}
