package alarm

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"strconv"
	"strings"
)

type Compare struct {
}

/**
	real < alter
 */
func (Compare) Less(alter string, real []string) bool {
	rs := true
	lastIndex := len(real) - 1
	for i, r := range real {
		if i != 0 || i != lastIndex {
			rs = rs && (r < alter)
		}
	}
	return rs
}

func (Compare) Greater(alter string, real []string) bool {
	rs := true
	lastIndex := len(real) - 1
	for i, r := range real {
		if i != 0 || i != lastIndex {
			rs = rs && (r > alter)
		}
	}
	return rs
}

/**
	real = alter
 */
func (Compare) Equal(alter string, real []string) bool {
	rs := true
	lastIndex := len(real) - 1
	for i, r := range real {
		if i != 0 || i != lastIndex {
			rs = rs && (r == alter)
		}
	}
	return rs
}

//限制同比
func (Compare) LimitComparedWithSame(alter string, old []string, current []string) bool {
	logger.Info.Println("old:", strings.Join(old, ","), "new: ", strings.Join(current, ","))
	rs := true
	lastIndex := len(current) - 1
	for i, r := range current {
		if i != 0 || i != lastIndex {
			rs = rs && limitCompareSame(alter, old[i], r)
		}
	}
	return rs
}

/**
	同比超过alter
 */
func (Compare) ComparedWithSame(alter string, old []string, current []string) bool {
	logger.Info.Println("old:", strings.Join(old, ","), "new: ", strings.Join(current, ","))
	rs := true
	lastIndex := len(current) - 1
	for i, r := range current {
		if i != 0 || i != lastIndex {
			rs = rs && compareSame(alter, old[i], r)
		}
	}
	return rs

}

func limitCompareSame(alter string, old string, current string) bool {
	cf := parseToFloat(current)
	of := parseToFloat(old)
	if cf < 200 && of < 200 {
		return false
	}
	return (cf-of)/of > parseToFloat(alter)
}

func compareSame(alter string, old string, current string) bool {
	cf := parseToFloat(current)
	of := parseToFloat(old)
	return (cf-of)/of > parseToFloat(alter)
}

func parseToFloat(value string) float64 {
	rs, err := strconv.ParseFloat(value, 64)
	if nil != err {
		logger.Error.Println(err)
	}
	return rs
}

type MsgBuilder struct {
}

func (MsgBuilder) Less(alter string) string {
	return fmt.Sprintf(" 低于阈值：%s", alter)
}

/**
	real > alter
 */
func (MsgBuilder) Greater(alter string) string {
	return fmt.Sprintf(" 高于阈值：%s", alter)
}

/**
	real = alter
 */
func (MsgBuilder) Equal(alter string) string {
	return fmt.Sprintf(" 等于阈值：%.3s", alter)
}

/**
	同比超过alter
 */
func (MsgBuilder) ComparedWithSame(alter string) string {
	return "同比超过" + alter
}


//限制同比
func (MsgBuilder) LimitComparedWithSame(alter string) string {
	return "同比超过" + alter
}