package registry

import (
	"fmt"
	"strconv"
	"testing"
	"time"
)

var r Registry = nil

func TestRefreshService(t *testing.T) {
	TestNew(t)

	if e := r.Init(map[string]interface{}{"dc": "3c", "cluster": []string{"172.30.12.4:8500"}}); e != nil {
		t.Error(e)
	}

	time.Sleep(time.Second * 1)

	smap := r.GetServiceMap()
	for _, service := range smap {
		println("-------------|", service.Name, "|-------------")
		for _, node := range service.NodeMap {
			fmt.Println(node)
		}
	}

	time.Sleep(time.Second * 1)

	for _, service := range smap {
		println("-------------|", service.Name, "|-------------")
		for _, node := range service.NodeMap {
			_ = r.Deregister(node.Id)
//			_ = r.Register(node)
		}
	}

	time.Sleep(time.Second * 1)

	r2 := New("consul")
	if e := r2.Init(map[string]interface{}{"dc": "3c", "cluster": []string{"172.30.12.2:8500"}}); e != nil {
		t.Error(e)
	}

	for _, service := range smap {
		println("-------------|", service.Name, "|-------------")
		for _, node := range service.NodeMap {
//			_ = r.Deregister(node.Id)
			_ = r2.Register(node)
		}
	}
}

func TestNew(t *testing.T) {
	if r == nil {
		r = New("consul")
	}
	if r == nil {
		t.Error("consul new error")
	}
}

func TestConsulRegistry_Init(t *testing.T) {
	TestNew(t)

	if e := r.Init(map[string]interface{}{"cluster": []string{"192.168.29.69:8500", "192.168.29.70:8500", "192.168.29.71:8500"}}); e != nil {
		t.Error(e)
	}

	select {}
}

func TestConsulRegistry_Register(t *testing.T) {
	TestNew(t)
	go TestConsulRegistry_Init(t)

	for i := 0; i < 10; i++ {
		time.Sleep(time.Second * 1)
		node := Node{
			ServiceName: "name:" + strconv.Itoa(i/2),
			Id:          strconv.Itoa(i),
			Address:     "192.168.1.1",
			Port:        123,
			Meta:        nil,
			Status:      "",
		}
		println("re:", i)
		if e := r.Register(&node); e != nil {
			t.Error(e)
		}
	}
}

func TestConsulRegistry_Deregister(t *testing.T) {
	TestConsulRegistry_Register(t)
	time.Sleep(time.Second * 5)
	for i := 0; i < 10; i++ {
		time.Sleep(time.Second * 1)
		println("de:", i)
		if e := r.Deregister(strconv.Itoa(i)); e != nil {
			t.Error(e)
		}
	}
}

func TestConsulRegistry_GetServiceMap(t *testing.T) {
	go TestConsulRegistry_Deregister(t)
	for i := 0; i < 60; i++ {
		time.Sleep(time.Second * 1)
		s := r.GetServiceMap()
		for _, v := range s {
			fmt.Println("~~~~~~~~~~~~~~:", v.Name, v.TagMap, ":~~~~~~~~~~~~")
			for _, n := range v.NodeMap {
				fmt.Println(n)
			}
		}
	}
}

func TestConsulRegistry_GetService(t *testing.T) {
	TestConsulRegistry_Register(t)
	if s, e := r.GetService("name:0"); e != nil {
		t.Error(e)
	} else {
		fmt.Println(s.Name)
	}

	if _, e := r.GetService("xxx"); e == nil {
		t.Error("GetService err")
	}
}

type TObserver struct {
}

func (to *TObserver) DeleteService(serviceName string) {
	fmt.Println(serviceName)
}
func (to *TObserver) UpdateNodes(_ *Service, node *Node) {
	fmt.Println(node)
}

func TestConsulRegistry_SetObserver(t *testing.T) {
	go TestConsulRegistry_Deregister(t)
	time.Sleep(time.Second * 5)
	_ = r.SetObserver("test", &TObserver{})
	time.Sleep(time.Second * 5)
	_ = r.DelObserver("test")
	select {}
}
