package service

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/service/util"
	"net/http"
	"strconv"
	"strings"
)

func DurationInterface(w http.ResponseWriter, r *http.Request) {
	day := r.Header.Get("day")
	DurationCalcAndSendEmail(day)
	fmt.Fprint(w)
}

func DurationCalcAndSendEmail(day string) {
	info := ""
	Duration(day, func(sysName string, durations map[string]string) {
		info = info + "\n" + "系统名称 : " + strings.Split(sysName, ":")[1] + "\n"
		for k, v := range durations {
			i, err := strconv.Atoi(v)
			if err != nil {
				fmt.Print("转换类型出错了. ", err)
			}
			i = i / 1000
			info = info + k + " , 耗时:" + strconv.Itoa(i) + "ms" + "\n"
		}
	})
	util.SendEmail("接口耗时情况"+day, info, "xiaoguang.xu@quantgroup.cn")
}

func CounterInterface(w http.ResponseWriter, r *http.Request) {
	day := r.Header.Get("day")
	CounterCalcAndSendEmail(day)
	fmt.Fprint(w)
}

func CounterCalcAndSendEmail(day string) {
	info := ""
	Counter(day, func(sysName string, durations map[string]string) {
		info = info + "\n" + "系统名称 : " + strings.Split(sysName, ":")[1] + "\n"
		for k, v := range durations {
			info = info + k + " , 次数:" + v + "\n"
		}
	})
	util.SendEmail("接口调用量"+day, info, "xiaoguang.xu@quantgroup.cn","nan.sun@quantgroup.cn")
}
