package report_form

import "time"

type Service struct {
	name    string
	pathMap map[string]*TraceList
}

func NewService(name string) *Service {
	return &Service{
		name:    name,
		pathMap: make(map[string]*TraceList),
	}
}

//添加trace
func (s *Service) AddTrace(path string, trace *Trace) {
	if _, ok := s.pathMap[path]; !ok {
		s.pathMap[path] = NewTraceList(path)
	}

	s.pathMap[path].AddTrace(trace)
}

//删除path
func (s *Service) DelPath(path string) {
	delete(s.pathMap, path)
}

//求服务的平均响应时间
func (s *Service) GetAverageTime() time.Duration {
	count := s.GetCount()
	if count == 0 {
		return 0
	}

	sum := time.Duration(0)
	for _, v := range s.pathMap {
		for _, vv := range v.traceList {
			sum += vv.Duration
		}
	}

	return sum / time.Duration(count)
}

//求服务的访问量
func (s *Service) GetCount() int {
	sum := 0
	for _, v := range s.pathMap {
		sum += v.GetCount()
	}
	return sum
}
