package report_form

import "time"

type ServiceMap struct {
	serviceMap map[string]*Service
}

func NewServiceMap() *ServiceMap {
	return &ServiceMap{
		serviceMap: make(map[string]*Service),
	}
}

//添加trace
func (sm *ServiceMap) AddTrace(service string, path string, trace *Trace) {
	if _, ok := sm.serviceMap[service]; !ok {
		sm.serviceMap[service] = NewService(service)
	}

	sm.serviceMap[service].AddTrace(path, trace)
}

//获取service
func (sm *ServiceMap) GetService(service string) (*Service, bool) {
	s, ok := sm.serviceMap[service]
	return s, ok
}

//求服务的平均响应时间
func (sm *ServiceMap) GetAverageTime() time.Duration {
	count := sm.GetCount()
	if count == 0 {
		return 0
	}

	sum := time.Duration(0)
	for _, v := range sm.serviceMap {
		for _, vv := range v.pathMap {
			for _, vvv := range vv.traceList {
				sum += vvv.Duration
			}
		}
	}

	return sum / time.Duration(count)
}

//求服务的访问量
func (sm *ServiceMap) GetCount() int {
	sum := 0
	for _, v := range sm.serviceMap {
		sum += v.GetCount()
	}
	return sum
}
