package main

import (
	"flag"
	"git.quantgroup.cn/DevOps/enoch/service"
	"git.quantgroup.cn/DevOps/enoch/service/conf"
	"git.quantgroup.cn/DevOps/enoch/service/data"
	"git.quantgroup.cn/DevOps/enoch/service/job"
	"log"
	"net/http"
	_ "net/http/pprof"
	"os"
	"strconv"
)

func main() {
	var port string
	var quartz bool
	var denv string
	flag.StringVar(&port, "port", "10086", "端口")
	flag.BoolVar(&quartz, "quartz", false, "quartz")
	flag.StringVar(&denv, "env", "dev", "环境")
	flag.Parse()
	conf.Load(denv)

	file, err := os.OpenFile("quantgroup.log", os.O_RDWR|os.O_CREATE, 0666)
	defer func() { _ = file.Close() }()
	if err != nil {
		log.Fatalln("create file error", err)
	}

	logger := log.New(file, "[Info]", log.LstdFlags|log.Llongfile)

	logger.Println(conf.GlobalConfig.AppName + "项目启动, port:" + port + ",环境:" + conf.GlobalConfig.Env)
	defer logger.Println("项目结束")

	//初始化redis连接池
	data.RedisPoolInit()

	go service.AgentClusterConsumer(conf.HealthTopic(), service.HealthMessageHandler{})
	go service.AgentClusterConsumer(conf.BraveTopic(), service.BraveMessageHandler{})
	intPort, _ := strconv.Atoi(port)

	if quartz {
		log.Println("启动定时任务")
		job.AutoEmailPerformInfo()
	}

	go func() {
		http.ListenAndServe("0.0.0.0:"+strconv.Itoa(intPort+1), nil)
	}()

	http.HandleFunc("/duration", service.DurationInterface)
	http.HandleFunc("/counter", service.CounterInterface)

	err = http.ListenAndServe(":"+port, nil)
	if err != nil {
		log.Fatalln("服务启动失败", err)
	}

}
