package alarm

import (
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"strconv"
	"strings"
)

type Compare struct {
}

/**
	real < alter
 */
func (Compare) Less(alter string, real string) bool {
	return real < alter
}

/**
	real > alter
 */
func (Compare) Greater(alter string, real string) bool {
	return real > alter
}

/**
	real = alter
 */
func (Compare) Equal(alter string, real string) bool {
	return real == alter
}

func (Compare) Between(floor string, ceil string, real string) bool {
	return floor < real && ceil > real
}

/**
	同比超过alter
 */
func (Compare) ComparedWithSame(alter string, old string, current string) bool {
	cf := parseToFloat(current)
	of := parseToFloat(old)
	return (cf-of)/of > parseToFloat(alter)
}

func parseToFloat(value string) float64 {
	rs, err := strconv.ParseFloat(value, 64)
	if nil != err {
		logger.Error.Println(err)
	}
	return rs
}

type MsgBuilder struct {
}

func (MsgBuilder) Less(alter string, real string) string {
	str := strings.Builder{}
	str.WriteString("的值为：")
	str.WriteString(real)
	str.WriteString("已经低于阈值：")
	str.WriteString(alter)
	return str.String()
}

/**
	real > alter
 */
func (MsgBuilder) Greater(alter string, real string) string {
	str := strings.Builder{}
	str.WriteString("的值为：")
	str.WriteString(real)
	str.WriteString("已经高于阈值：")
	str.WriteString(alter)
	return str.String()
}

/**
	real = alter
 */
func (MsgBuilder) Equal(alter string, real string) string {
	str := strings.Builder{}
	str.WriteString("的值为：")
	str.WriteString(real)
	str.WriteString("已经达到阈值：")
	str.WriteString(alter)
	return str.String()
}

func (MsgBuilder) Between(floor string, ceil string, real string) string {
	str := strings.Builder{}
	str.WriteString("的值为：")
	str.WriteString(real)
	str.WriteString("已经介于阈值：")
	str.WriteString(ceil)
	str.WriteString("~")
	str.WriteString(floor)
	str.WriteString("之间")
	return str.String()
}

/**
	同比超过alter
 */
func (MsgBuilder) ComparedWithSame(alter string, old string, current string) string {
	return "同比超过" + alter
}
