package main

import (
	"flag"
	"git.quantgroup.cn/DevOps/enoch/service"
	"git.quantgroup.cn/DevOps/enoch/service/conf"
	"git.quantgroup.cn/DevOps/enoch/service/job"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"log"
	"net/http"
	_ "net/http/pprof"
	"strconv"
)

func main() {
	var port string
	var quartz bool
	var denv string
	var didc string
	flag.StringVar(&port, "port", "10086", "端口")
	flag.BoolVar(&quartz, "quartz", false, "quartz")
	flag.StringVar(&denv, "env", "dev", "环境")
	flag.StringVar(&didc, "idc", "local", "机房")
	flag.Parse()
	conf.Load(denv, didc)

	logger.Info.Println(conf.GlobalConfig.AppName + "项目启动, port:" + port + ",环境:" + conf.GlobalConfig.Env)
	defer logger.Info.Println("项目结束")

	//初始化redis连接池
	//data.RedisPoolInit()

	//初始化alarm

	//初始化kafka 消费者
	//go service.AgentClusterConsumer(conf.HealthTopic(), service.HealthMessageHandler{})
	//go service.AgentClusterConsumer(conf.BraveTopic(), service.BraveMessageHandler{})
	intPort, _ := strconv.Atoi(port)

	if quartz {
		log.Println("启动定时任务")
		//job.AutoEmailPerformInfo()
		job.AutoAlarm()
	}

	go func() {
		http.ListenAndServe("0.0.0.0:"+strconv.Itoa(intPort+1), nil)
	}()

	http.HandleFunc("/duration", service.DurationInterface)
	http.HandleFunc("/counter", service.CounterInterface)
	err := http.ListenAndServe(":"+port, nil)
	if err != nil {
		logger.Error.Fatalln("服务启动失败", err)
	}


}
