package conf

import "time"

type Config struct {
	AppName string `json:"app_name"`
	Port string `json:"port"`
	Env string
	Redis Redis `json:"redis"`
	Kafka Kafka `json:"kafka"`
	InfluxDb InfluxDb `json:"influx_db"`
}

type Redis struct {
	Host string `json:"host"`
	Port string `json:"port"`
	MaxIdle int `json:"max_idle"`
	MaxActive int `json:"max_active"`
	IdleTimeout time.Duration `json:"idle_timeout"`
}

type Kafka struct {
	Brokers []string `json:"brokers"`
}

type InfluxDb struct {
	 Host string `json:"host"`
	 Port string `json:"port"`
}

