package dao

import (
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"github.com/influxdata/influxdb/client/v2"
	"time"
)

func DbInit() {
	config := client.HTTPConfig{
		Addr:    global.InfluxDbAddress,
		Timeout: time.Second * 4,
	}
	c, err := client.NewHTTPClient(config)
	if err != nil {
		glog.Error("can not new influxdb http client")
		return
	}

	//如果数据库不存在，创建数据库，可重复创建不会覆盖掉原数据库
	if _, err := c.Query(client.Query{Command: "create database " + global.InfluxDbName}); err != nil {
		glog.Error(err)
		return
	}
}
