package continuous_queries

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/service/conf"
	"git.quantgroup.cn/DevOps/enoch/service/data"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"github.com/vrg0/go-common/logger"
	"strings"
)

var (

func query(dbName string) []string {
	cq := data.QueryMonitor(SHOW_CQ_SQL)
	logger.Info.Println(cq)
	cqName := make([]string, 0)
	for _, row := range cq[0].Series {
		if row.Name == dbName {
			for _, v := range row.Values {
				cqName = append(cqName, v[0].(string))
			}
		}
	}
	return cqName
}

func delete(db string, cqName [] string) bool {
	sql := strings.Builder{}
	for _, name := range cqName {
		sql.WriteString(fmt.Sprintf(DROP_CQ_SQL, name, db))
	}
	rs := data.QueryMonitor(sql.String())
	return rs == nil
}

func create(apdexThreshold conf.ApdexThreshold) {
	sysName := data.QuerySysName()
	logger.Info.Println(sysName)
	sql := strings.Builder{}
	for _, name := range sysName {
		cqName := strings.Replace(name, "-", "_", 10)
		threshold := apdexThreshold.Common
		if c, ok := apdexThreshold.Personal[name]; ok {
			threshold = c
		}
		sql.WriteString(buildSatSql(cqName, name, threshold))
		sql.WriteString(buildTolSql(cqName, name, threshold))
	}
	sql.WriteString(APDEX_CQ_ALL)
	data.QueryMonitor(sql.String())
}

func buildSatSql(cqName string, sysName string, threshold int) string {
	return fmt.Sprintf(APDEX_CQ_SAT, cqName, sysName, threshold)
}

func buildTolSql(cqName string, sysName string, threshold int) string {
	return fmt.Sprintf(APDEX_CQ_TOL, cqName, sysName, threshold, threshold*4)
}

func Load() {
	name := query(data.MONITOR)
	logger.Info.Println("old: ", name)
	delete(data.MONITOR, name)
	create(conf.GlobalConfig.ApdexThreshold)
	name = query(data.MONITOR)
	logger.Info.Println("new: ", name)
}
