package report_form

import (
	"testing"
	"time"
)

func TestNewServiceMap(t *testing.T) {
	sm := NewServiceMap(time.Now().Add(time.Hour*24*-7), time.Now())

	t.Log("访问量：", sm.GetCount())
	t.Log("总访问时间：", sm.GetSumDuration())
	t.Log("总平均访问时间：", sm.GetAverageDuration())
	t.Log("------------------median-------------------")
	medianList := sm.GetMedianDurationPathList()
	for _, m := range medianList {
		t.Log(m.GetMedianDuration(), m.GetServiceName(), m.GetPath(), m.GetCount())
	}
	t.Log("------------------average------------------")
	averageList := sm.GetAverageDurationPathList()
	for _, m := range averageList {
		t.Log(m.GetAverageDuration(), m.GetServiceName(), m.GetPath(), m.GetCount())
	}
	t.Log("------------------max----------------------")
	maxList := sm.GetMaxDurationTracePointList()
	for _, m := range maxList {
		t.Log(m.Duration, m.ServiceName, m.Path, m.Timestamp, m.TraceId)
	}
	t.Log("------------------cpu----------------------")
	cpuList := sm.GetAverageCpuServiceList()
	for _, s := range cpuList {
		t.Log(s.Name(), s.GetAverageCpu())
	}
	t.Log("------------------mem----------------------")
	memList := sm.GetMaxMemServiceList()
	for _, s := range memList {
		t.Log(s.Name(), s.GetAverageMem())
	}
	t.Log("------------------disk---------------------")
	diskList := sm.GetMaxDiskServiceList()
	for _, s := range diskList {
		t.Log(s.Name(), s.GetAverageDisk())
	}
}
