package job

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/service"
	"github.com/robfig/cron"
	"time"
)

func AutoEmailPerformInfo() {
	c := cron.New()

	err := c.AddFunc("@midnight", func() {
		day := time.Now().Add(-1 * 24 * time.Hour).Format("20060102")
		service.CounterCalcAndSendEmail(day)
		service.DurationCalcAndSendEmail(day)
	})
	if err != nil {
		fmt.Print("err")
	}

	c.Start()
}
