package end_points

type ChunkMsg struct {
	AppName   string     `json:"appName"`
	Ip        string     `json:"ip"`
	EndPoints []EndPoint `json:"endPoints"`
}

type EndPoint struct {
	Health    Health      `json:"health"`
	Metrics   MetricsInfo `json:"metrics"`
	Timestamp int64       `json:"timestamp"`
}
type Health struct {
	Status  Status `json:"status"`
	Details Detail `json:"details"`
}

type Detail struct {
	DiskSpace DiskInfo  `json:"diskSpace"`
	Redis     RedisInfo `json:"redis"`
	Db        interface{}    `json:"db"`

}

type DBInfo struct {
	Details map[string]DBDetail `json:"details"`
	Status  Status              `json:"status"`
}

type DBDetail struct {
	Status  Status       `json:"status"`
	Details DBDetailInfo `json:"details"`
}

type DBDetailInfo struct {
	Database string `json:"database"`
}

/**
	硬盘信息
 */
type DiskInfo struct {
	Details DiskDetail `json:"details"`
	Status  Status     `json:"status"`
}

/**
	硬盘详情
 */
type DiskDetail struct {
	Total     int64 `json:"total"`
	Free      int64 `json:"free"`
	Threshold int64 `json:"threshold"`
}

/**
	redis
 */
type RedisInfo struct {
	Status Status `json:"status"`
}

type Status struct {
	Code        string `json:"code"`
	Description string `json:"description"`
}

type MetricsInfo struct {
	Mem                        int     `json:"mem"`
	MemFree                    int     `json:"mem.free"`
	Processors                 int     `json:"processors"`
	InstanceUptime             int     `json:"instance.uptime"`
	Uptime                     int     `json:"uptime"`
	SystemloadAverage          float64 `json:"systemload.average"`
	HeapCommitted              int     `json:"heap.committed"`
	HeapInit                   int     `json:"heap.init"`
	HeapUsed                   int     `json:"heap.used"`
	Heap                       int     `json:"heap"`
	NonheapCommitted           int     `json:"nonheap.committed"`
	NonheapInit                int     `json:"nonheap.init"`
	NonheapUsed                int     `json:"nonheap.used"`
	Nonheap                    int     `json:"nonheap"`
	ThreadsPeak                int     `json:"threads.peak"`
	ThreadsDaemon              int     `json:"threads.daemon"`
	ThreadsTotalStarted        int     `json:"threads.totalStarted"`
	Threads                    int     `json:"threads"`
	Classes                    int     `json:"classes"`
	ClassesLoaded              int     `json:"classes.loaded"`
	ClassesUnloaded            int     `json:"classes.unloaded"`
	GcParnewCount              int     `json:"gc.parnew.count"`
	GcParnewTime               int     `json:"gc.parnew.time"`
	GcConcurrentmarksweepCount int     `json:"gc.concurrentmarksweep.count"`
	GcConcurrentmarksweepTime  int     `json:"gc.concurrentmarksweep.time"`
}
