package conf

import "time"

type Config struct {
	AppName string `json:"app_name"`
	Port string `json:"port"`
	Env string
	Redis Redis `json:"redis"`
	Kafka Kafka `json:"kafka"`
	InfluxDb InfluxDb `json:"influx_db"`
	ApdexThreshold ApdexThreshold `json:"apdex_threshold"`
	StrategyConfPath string `json:"strategy_conf_path"`
	FileCachePath string `json:"file_cache_path"`
}

type Redis struct {
	Host string `json:"host"`
	Port string `json:"port"`
	MaxIdle int `json:"max_idle"`
	MaxActive int `json:"max_active"`
	IdleTimeout time.Duration `json:"idle_timeout"`
}

type Kafka struct {
	Brokers []string `json:"brokers"`
}

type InfluxDb struct {
	 Host string `json:"host"`
	 Port string `json:"port"`
}

type ApdexThreshold struct {
	Common int `json:"common"`
	Personal map[string]int `json:"personal"`
}
