package report_form

import (
	"encoding/json"
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"github.com/vrg0/go-common/util"
	"io/ioutil"
	"os"
	"runtime/debug"
	"time"
)

//定期报表，保存到指定文件夹
func RegularReport(dir string) {
	if !util.IsDir(dir) {
		return
	}

	go func() {
		defer func() {
			if err := recover(); err != nil {
				glog.Error(err, "\n", string(debug.Stack()))
			}

		}()

		timer := time.NewTimer(0)
		for {
			<-timer.C
			now := time.Now()

			run(now, dir)

			next := now.Add(time.Hour * 24)
			next = time.Date(next.Year(), next.Month(), next.Day(), 1, 0, 0, 0, next.Location())
			timer.Reset(next.Sub(now))
		}
	}()
}

func run(now time.Time, dir string) {
	fileNamePrefix := now.Add(time.Hour * -24).Format("2006-01-02")
	dir = dir + "/" + fileNamePrefix
	dirDay := dir + "/" + "day"
	dirWeek := dir + "/" + "week"
	if util.Exists(dir) {
		return
	} else {
		if err := os.Mkdir(dir, os.ModePerm); err != nil {
			glog.Error("创建dir失败:", dir, ":", err)
			return
		}
	}

	//周表
	if err := os.Mkdir(dirWeek, os.ModePerm); err != nil {
		glog.Error("创建dir失败:", dirWeek, ":", err)
		return
	} else {
		reportForm(now, dirWeek, 7)
	}

	//日表
	if err := os.Mkdir(dirDay, os.ModePerm); err != nil {
		glog.Error("创建dir失败:", dirDay, ":", err)
		return
	} else {
		reportForm(now, dirDay, 1)
	}
}

var serviceList []string = nil

func init() {
	global.Config.Watch(global.NamespaceApplication, "service.list", func(oldCfg string, newCfg string) {
		newList := make([]string, 0)
		if err := json.Unmarshal([]byte(newCfg), &newList); err != nil {
			glog.Error("service.list can not unmarshal json:", err)
			return
		}
		serviceList = newList
	})
}

func reportForm(t time.Time, dir string, n int) {
	startTime := t.Add(-1 * time.Duration(t.Hour()) * time.Hour)
	startTime = startTime.Add(-1 * time.Duration(t.Minute()) * time.Minute)
	startTime = startTime.Add(-1 * time.Duration(t.Second()) * time.Second)
	startTime = startTime.Add(-1 * time.Duration(t.Nanosecond()))
	startTime = startTime.AddDate(0, 0, -n)
	endTime := startTime.AddDate(0, 0, n)

	glog.Info("报表开始：", startTime.Format(timeFormat), " ~ ", endTime.Format(timeFormat))
	sm := NewServiceMap(startTime, endTime, serviceList)

	long := "day"
	if n == 7 {
		long = "week"
	}

	//总表
	all := sm.ReportForm(long)
	if err := ioutil.WriteFile(dir+"/all.html", []byte(all), os.ModePerm); err != nil {
		glog.Error("写入文件失败", dir, " all.html ", err)
		return
	}

	//分表
	for name, s := range sm.GetServiceMap() {
		data := s.ReportForm(long)
		if err := ioutil.WriteFile(dir+"/"+name+".html", []byte(data), os.ModePerm); err != nil {
			glog.Error("写入文件失败", dir, " ", name, ".html ", err)
			return
		}
	}
	glog.Info("报表结束")

	//原始数据
	/*
		buf := new(bytes.Buffer)
		enc := gob.NewEncoder(buf)
		if err := enc.Encode(sm); err != nil {
			glog.Error("报表：原始数据编码失败:", err)
			return
		}
		data := buf.Bytes()
		if err := ioutil.WriteFile(dir + "/" + "origin", data, 0644); err != nil {
			glog.Error("报表：原始数据写入文件失败:", err)
			return
		}
	*/
}
