package conf

import (
	"flag"
	"github.com/gomodule/redigo/redis"
	"time"
)

func newPool(server, password string) *redis.Pool {

	return &redis.Pool{
		MaxIdle:     0,
		MaxActive:   5000,
		IdleTimeout: 120 * time.Second,
		Dial: func() (redis.Conn, error) {
			conn, err := redis.Dial("tcp", server)
			if err != nil {
				return nil, err
			}
			if password != "" {
				if _, err := conn.Do("AUTH", password); err != nil {
					conn.Close()
					return nil, err
				}
			}
			return conn, err
		},
		TestOnBorrow: func(conn redis.Conn, t time.Time) error {
			_, err := conn.Do("PING")
			return err
		},
		Wait: true,
	}
}

var (
	Pool          *redis.Pool
	redisServer   = flag.String("redisServer", "172.30.12.2:6379", "")
	redisPassword = flag.String("redisPassword", "", "")
)

func RedisPoolInit() {
	flag.Parse()
	Pool = newPool(*redisServer, *redisPassword)
}
