package report_form

import (
	"math"
	"sort"
	"time"
)

type Trace struct {
	Id          string
	ServiceName string
	Host        string
	Path        string
	Duration    time.Duration
	TimePoint   time.Time
}

func NewTrace(id string, serviceName string, host string, path string, duration time.Duration, timePoint time.Time) *Trace {
	return &Trace{
		Id:          id,
		ServiceName: serviceName,
		Host:        host,
		Path:        path,
		Duration:    duration,
		TimePoint:   timePoint,
	}
}

type TraceList struct {
	Path      string
	traceList []*Trace
	isSort    bool
}

func NewTraceList(path string) *TraceList {
	return &TraceList{
		Path:      path,
		traceList: make([]*Trace, 0),
	}
}

func (tl *TraceList) AddTrace(trace *Trace) {
	tl.traceList = append(tl.traceList, trace)
	tl.isSort = false
}

func (tl *TraceList) GetTraceList() []*Trace {
	tl.sortTime()
	return tl.traceList
}

func (tl *TraceList) GetPath() string {
	return tl.Path
}

//排序
func (tl *TraceList) sortTime() {
	if tl.isSort {
		return
	}

	sort.Slice(tl.traceList, func(i, j int) bool {
		if tl.traceList[i].Duration < tl.traceList[j].Duration {
			return false
		}
		return true
	})
	tl.isSort = true
}

//获取平均值
func (tl *TraceList) GetAverageTime() time.Duration {
	if len(tl.traceList) == 0 {
		return 0
	}

	sum := time.Duration(0)
	for _, v := range tl.traceList {
		sum += v.Duration
	}
	return sum / time.Duration(len(tl.traceList))
}

//获取中位trace
func (tl *TraceList) GetMediaTrace() (*Trace, bool) {
	if len(tl.traceList) == 0 {
		return nil, false
	}

	tl.sortTime()
	return tl.traceList[len(tl.traceList)/2], true
}

//获取最大trace
func (tl *TraceList) GetMaxTrace() (*Trace, bool) {
	if len(tl.traceList) == 0 {
		return nil, false
	}

	tl.sortTime()
	return tl.traceList[0], true
}

//获取最小trace
func (tl *TraceList) GetMinTrace() (*Trace, bool) {
	if len(tl.traceList) == 0 {
		return nil, false
	}

	tl.sortTime()
	return tl.traceList[len(tl.traceList)-1], true
}

//获取请求次数
func (tl *TraceList) GetCount() int {
	return len(tl.traceList)
}

//标准差
//注：标准差越大说明分布越不稳定
func (tl *TraceList) GetStandardDeviation() float64 {
	if len(tl.traceList) == 0 {
		return 0
	}

	average := tl.GetAverageTime()
	sum := time.Duration(0)
	for _, v := range tl.traceList {
		sum += (average - v.Duration) * (average - v.Duration)
	}

	return math.Sqrt(float64(sum))
}
