package report_form

import (
	"testing"
	"time"
)

func TestGetServiceListFromDb(t *testing.T) {
	t.Log(GetServiceNameListFromDb())
}

func TestGetDataFromDb(t *testing.T) {
	end := time.Now().Add(time.Second * -600)
	start := end.AddDate(0, 0, -10)
	sm := GetDataFromDb(start, end)
	t.Log(sm.GetAverageTime(), sm.GetCount())

	tl := NewTraceList("")
	for _, v := range sm {
		if trace, ok := v.GetMaxMediaTrace(); ok {
			tl.AddTrace(trace)
		}
	}
	list := tl.GetTraceList()
	for _, v := range list {
		t.Log(v.Duration, v.ServiceName, v.Id, v.Path)
	}
}
