package report_form

import (
	"encoding/json"
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"github.com/influxdata/influxdb/client/v2"
	"github.com/influxdata/influxdb/models"
)

//查询
func query(sql string) (*client.Response, error) {
	config := client.HTTPConfig{
		Addr: global.InfluxDbAddress,
	}

	connect, err := client.NewHTTPClient(config)
	defer func() { _ = connect.Close() }()
	if err != nil {
		return nil, err
	}

	rtn, err := connect.Query(client.NewQuery(sql, global.InfluxDbName, ""))
	if err != nil {
		return nil, err
	}

	return rtn, nil
}

//获取row的index
func getModRowKeyIdx(key string, row models.Row) (int, bool) {
	for i, v := range row.Columns {
		if v == key {
			return i, true
		}
	}

	return -1, false
}

//查询单个结果
func queryOne(sql string) (interface{}, bool) {
	resp, err := query(sql)
	if err != nil {
		glog.Error("query One:", err)
		return nil, false
	}

	//过滤结果
	if len(resp.Results) != 1 {
		return nil, false
	}
	res := resp.Results[0]
	if len(res.Series) != 1 {
		return nil, false
	}
	row := res.Series[0]
	if len(row.Values) != 1 {
		return nil, false
	}
	v := row.Values[0]
	if len(v) != 2 {
		return nil, false
	}
	return v[1], true
}

//json.Number格式转换
func jsonNumberToInt(i interface{}) (int, bool) {
	j, ok := i.(json.Number)
	if !ok {
		return -1, false
	}
	rtn64, err := j.Int64()
	if err != nil {
		return -1, false
	}
	return int(rtn64), true
}

//查询并且转换成int
func queryOneAndToInt(sql string) (int, bool) {
	req, ok := queryOne(sql)
	if !ok {
		return -1, false
	}
	rtn, ok := jsonNumberToInt(req)
	if !ok {
		return -1, false
	}
	return rtn, true
}
