package node_up_down

import (
	"encoding/json"
	"errors"
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/pkg/api-server"
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"git.quantgroup.cn/DevOps/enoch/pkg/registry"
	"github.com/valyala/fasthttp"
	/*"github.com/vrg0/go-common/registry"*/
	"strconv"
	"strings"
)

func init() {
	api_server.HandlerFunc(api_server.POST, "/upstreams_dubbo/:nginx_upstream_name/targets", manageDubbo)
}

// 函数改名
func manageDubbo(ctx *fasthttp.RequestCtx) {
	//参数获取
	bodyParam := make(map[string]interface{})
	body := ctx.Request.Body()
	if err := json.Unmarshal(body, &bodyParam); err != nil {
		errStr := fmt.Sprint("服务上下线 Json解析失败: ", string(body), err)
		ctx.SetBodyString(errStr)
		ctx.SetStatusCode(400)
		glog.Warn(errStr)
		return
	}

	sysName, ok1 := ctx.UserValue("nginx_upstream_name").(string)
	target, ok2 := bodyParam["target"].(string)
	weight, ok3 := bodyParam["weight"].(float64)
	dep := bodyParam["dep"].(string)
	if !ok1 || !ok2 || !ok3 {
		errStr := fmt.Sprint("服务上下线 参数读取失败失败：", string(body))
		ctx.SetBodyString(errStr)
		ctx.SetStatusCode(400)
		glog.Warn(errStr)
		return
	}

	//强制上下线，默认关闭
	force := false
	if f, ok := bodyParam["force"].(bool); ok {
		force = f
	}

	//上下线
	if weight > 0 {
		glog.Info("服务上线开始: ", sysName, " ", target, " force=", force)
	} else {
		glog.Info("服务下线开始: ", sysName, " ", target, " force=", force)
	}
	if err := doUpDownDubbo(target, sysName, weight, force, dep); err != nil {
		ctx.SetBodyString(err.Error())
		ctx.SetStatusCode(400)
		glog.Warn(err)
		return
	} else if weight > 0 {
		glog.Info("服务上线成功: ", sysName, " ", target, " force=", force)
	} else {
		glog.Info("服务下线成功: ", sysName, " ", target, " force=", force)
	}
}

// 节点上下线
func doUpDownDubbo(target string, sysName string, weight float64, force bool, dep string) error {
	endpointList := strings.Split(target, ",")
	for _, endpoint := range endpointList {
		ipPortStr := strings.Split(endpoint, ":")
		if len(ipPortStr) != 2 {
			return errors.New("failure of target resolution: " + endpoint)
		}
		ip := ipPortStr[0]
		portStr := ipPortStr[1]
		port, err := strconv.Atoi(portStr)
		if err != nil {
			return errors.New("failure of target resolution: " + portStr)
		}
		var mate map[string]string
		if dep != "" {
			mate = make(map[string]string)
			mate["dep"] = dep
		}
		node := registry.NewNodeTimeOut(sysName, endpoint, ip, port, 10, mate)

		if weight > 0 {
			//获取metadata（非必须，可获取失败）
			/*			v, err := consul_kv.GetValue("node:" + sysName + ":" + endpoint)
						if err == nil {
							meta := make(map[string]string)
							if e := json.Unmarshal([]byte(v), &meta); e == nil {
								node.Meta = meta
							}
						}*/

			//上线
			if err := registry.RegisterDubbo(node); err != nil {
				glog.Info("服务上线失败: ", err.Error())
				//return errors.New("服务上线失败:" + err.Error())
			}
		} else {
			// 仅剩一个节点的时候不可以下线，强制下线忽略此步骤
			if !force {
				if service, ok := registry.GetService(node.ServiceName); ok && len(service.NodeMap) == 1 {
					if _, ok := service.NodeMap[node.Id]; ok {
						return errors.New("服务下线失败:服务仅剩一个可用节点")
					}
				}
			}

			//下线
			if err := registry.Deregister(node); err != nil {
				glog.Info("服务下线失败: ", err.Error())
				//return errors.New("服务下线失败:" + err.Error())
			}
		}
	}

	return nil
}
