package report_form

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"time"
)

func Run() {
	now := time.Now()
	startTime := now.Add(-1 * time.Duration(now.Hour()) * time.Hour)
	startTime = startTime.Add(-1 * time.Duration(now.Minute()) * time.Minute)
	startTime = startTime.Add(-1 * time.Duration(now.Second()) * time.Second)
	startTime = startTime.Add(-1 * time.Duration(now.Nanosecond()))
	startTime = startTime.AddDate(0, 0, -7)
	endTime := startTime.AddDate(0, 0, 7)
	glog.Info("startTime:", startTime.UnixNano(), " endTime:", endTime.UnixNano())

	sm := NewServiceMap(startTime, endTime)
	fmt.Println(sm.GetCount())
	/*

		t.Log("访问量：", sm.GetCount())
		t.Log("总访问时间：", sm.GetSumDuration())
		t.Log("总平均访问时间：", sm.GetAverageDuration())
		t.Log("------------------median-------------------")
		medianList := sm.GetMedianDurationPathList()
		t.Log("服务数量：", len(medianList))
		for _, m := range medianList {
			t.Log(m.GetMedianDuration(), m.GetServiceName(), m.GetPath(), m.GetCount())
		}
		t.Log("------------------average------------------")
		averageList := sm.GetAverageDurationPathList()
		t.Log("服务数量：", len(averageList))
		for _, m := range averageList {
			t.Log(m.GetAverageDuration(), m.GetServiceName(), m.GetPath(), m.GetCount())
		}
		t.Log("------------------max----------------------")
		maxList := sm.GetMaxDurationTracePointList()
		t.Log("服务数量：", len(maxList))
		for _, m := range maxList {
			t.Log(m.Duration, m.ServiceName, m.Path, m.Timestamp, m.TraceId)
		}
	*/
}
