package alarm

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"strconv"
)

type Compare struct {
}

/**
	real < alter
 */
func (Compare) Less(alter string, real string) bool {
	return real < alter
}

/**
	real > alter
 */
func (Compare) Greater(alter string, real string) bool {
	return real > alter
}

/**
	real = alter
 */
func (Compare) Equal(alter string, real string) bool {
	return real == alter
}

func (Compare) Between(floor string, ceil string, real string) bool {
	return floor < real && ceil > real
}

/**
	同比超过alter
 */
func (Compare) ComparedWithSame(alter string, old string, current string) bool {
	cf := parseToFloat(current)
	of := parseToFloat(old)
	return (cf-of)/of > parseToFloat(alter)
}

func parseToFloat(value string) float64 {
	rs, err := strconv.ParseFloat(value, 64)
	if nil != err {
		logger.Error.Println(err)
	}
	return rs
}

type MsgBuilder struct {
}



func (MsgBuilder) Less(alter string, real string) string {
	return fmt.Sprintf(" 当前值：%.3f, 低于阈值：%s",parseToFloat(real), alter)
}

/**
	real > alter
 */
func (MsgBuilder) Greater(alter string, real string) string {
	return fmt.Sprintf(" 当前值：%.3f, 高于阈值：%s", parseToFloat(real), alter)
}

/**
	real = alter
 */
func (MsgBuilder) Equal(alter string, real string) string {
	return fmt.Sprintf(" 当前值：%.3f, 等于阈值：%.3s", parseToFloat(real), alter)
}

func (MsgBuilder) Between(floor string, ceil string, real string) string {
	return fmt.Sprintf(" 当前值：%.3f, 介于于阈值：%s 和 %s 之间", parseToFloat(real), ceil, floor)

}

/**
	同比超过alter
 */
func (MsgBuilder) ComparedWithSame(alter string, old string, current string) string {
	return "同比超过" + alter
}
