package dingding

import (
	"encoding/json"
	"net/http"
	"strings"
)

var DefaultDingURL = []string{"https://oapi.dingtalk.com/robot/send?access_token=9ffab8e4ae5f94e0fbf84aa91c9cb474d9e3d5bd0bb3c2daffe4cdfe0c2cbbc7"}

type DinDingMsg struct {
	MsgType string `json:"msgtype"`
	//	Link    Link   `json:"link"`
	Text Text `json:"text"`
}

type Text struct {
	Content string `json:"content"`
}

func SenderDingDing(info string, receiver [] string) error {
	bodyStr := buildDingDingMsg(info)

	for _, r := range receiver {
		data := strings.NewReader(string(bodyStr))
		_, e := http.Post(r, "application/json;charset=utf-8", data)
		if e != nil {
			return e
		}
	}
	return nil
}

func buildDingDingMsg(info string) []byte {
	msg := DinDingMsg{
		MsgType: "text",
		Text:Text{
			Content:info,
		},
	}

	msgStr, _ := json.Marshal(msg)
	return msgStr

}
