package report_form

import (
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"github.com/vrg0/go-common/util"
	"io/ioutil"
	"os"
	"runtime/debug"
	"time"
)

//定期报表，保存到指定文件夹
func RegularReport(dir string) {
	if !util.IsDir(dir) {
		return
	}

	go func() {
		defer func() {
			if err := recover(); err != nil {
				glog.Error(err, "\n", string(debug.Stack()))
			}

		}()

		timer := time.NewTimer(0)
		for {
			<-timer.C
			now := time.Now()

			run(now, dir)

			next := now.Add(time.Hour * 24)
			next = time.Date(next.Year(), next.Month(), next.Day(), 10, 0, 0, 0, next.Location())
			timer.Reset(next.Sub(now))
		}
	}()
}

func run(now time.Time, dir string) {
	fileNamePrefix := now.Format("2006-01-02")
	dir = dir + "/" + fileNamePrefix
	dirDay := dir + "/" + "day"
	dirWeek := dir + "/" + "week"
	if util.Exists(fileNamePrefix) {
		return
	} else {
		if err := os.Mkdir(dir, os.ModePerm); err != nil {
			glog.Error("创建dir失败:", dir, ":", err)
			return
		}
	}

	//周表
	if err := os.Mkdir(dirWeek, os.ModePerm); err != nil {
		glog.Error("创建dir失败:", dirWeek, ":", err)
		return
	} else {
		reportForm(now, dirWeek, 7)
	}

	//日表
	if err := os.Mkdir(dirDay, os.ModePerm); err != nil {
		glog.Error("创建dir失败:", dirDay, ":", err)
		return
	} else {
		reportForm(now, dirDay, 1)
	}
}

func reportForm(t time.Time, dir string, n int) {
	startTime := t.Add(-1 * time.Duration(t.Hour()) * time.Hour)
	startTime = startTime.Add(-1 * time.Duration(t.Minute()) * time.Minute)
	startTime = startTime.Add(-1 * time.Duration(t.Second()) * time.Second)
	startTime = startTime.Add(-1 * time.Duration(t.Nanosecond()))
	startTime = startTime.AddDate(0, 0, -n)
	endTime := startTime.AddDate(0, 0, n)

	sm := NewServiceMap(startTime, endTime)
	all := sm.ServiceMapReportForm()
	if err := ioutil.WriteFile(dir+"/all.html", []byte(all), os.ModePerm); err != nil {
		glog.Error("写入文件失败", dir+"/all.html", " ", err)
		return
	}
}

//	fileNamePrefix := now.Format("2006-01-02")

//周表
//	if now.Weekday() == time.Monday {
//		week()
//	}

/*
	//周表
	if now.Weekday() == time.Tuesday {
		sm := GeneralTableNewSM(7)

		//总表
		fileName := dir + "/" + fileNamePrefix + "_week.txt"
		if !util.Exists(fileName) {
			body := GeneralTableRun(sm)
			if err := ioutil.WriteFile(fileName, []byte(body), 0644); err != nil {
				glog.Error("报表写入文件失败：", fileName, err)
				glog.Info(body)
			}
			email.SendEmail("服务监控状态总表-"+fileNamePrefix, body, receiverList...)
		}
		glog.Info("每周总表报表完成:", fileName)

		//分表
		for name, service := range sm.serviceMap {
			fileName := dir + "/" + fileNamePrefix + "_" + name + "_week.txt"
			if !util.Exists(fileName) {
				body := SubTableRun(service)
				if err := ioutil.WriteFile(fileName, []byte(body), 0644); err != nil {
					glog.Error("报表写入文件失败：", fileName, err)
					glog.Info(body)
				}

				//如果存在，则发送邮件
				serviceOwnerEmailList, ok := serviceOwner[name]
				if !ok {
					continue
				}
				email.SendEmail(fileNamePrefix+"-服务健康状态表："+name, body, serviceOwnerEmailList...)
			}
		}
	}
*/

/*
var (
	receiverList = make([]string, 0)
	serviceOwner = make(map[string][]string)
)

func init() {
	global.Config.Watch(global.NamespaceApplication, "report.form.receiver", func(oldCfg string, newCfg string) {
		rList := make([]string, 0)
		if err := json.Unmarshal([]byte(newCfg), &rList); err != nil {
			glog.Error("can not unmarshal json:", err, " ", newCfg)
			return
		}
		receiverList = rList
	})

	global.Config.Watch(global.NamespaceApplication, "service.owner", func(oldCfg string, newCfg string) {
		obj := make(map[string][]string)
		if err := json.Unmarshal([]byte(newCfg), &obj); err != nil {
			glog.Error("can not unmarshal json:", err, " ", newCfg)
			return
		}
		serviceOwner = obj
	})
}

*/
