package alarm

import (
	"encoding/json"
	"git.quantgroup.cn/DevOps/enoch/service/conf"
	"git.quantgroup.cn/DevOps/enoch/service/data"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"io/ioutil"
)

func Load() {
	config,err := ioutil.ReadFile(conf.GlobalConfig.StrategyConfPath)
	if err != nil {
		logger.Error.Fatal("未找到配置文件")
	}

	strategies := make([]Strategy, 0)
	err = json.Unmarshal(config, &strategies)

	if err != nil {
		logger.Error.Fatal("策略文件格式错误:", err)
	}

	if !CheckArray(strategies) {
		logger.Error.Fatal("策略文件未通过校验")
	}

	sql := BuildSql(strategies)
	result := data.QueryMonitor(sql)
	DealResult(result, strategies)

}
