package cn.quantgroup.tech.brave.interceptor.impl;

import cn.quantgroup.tech.brave.handler.TokenHandler;
import cn.quantgroup.tech.brave.interceptor.OkHttpClientInterceptor;
import cn.quantgroup.tech.brave.interceptor.RequestInterceptor;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;

public class OkHttpClientAuthInterceptor extends RequestInterceptor implements OkHttpClientInterceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        requestBuilder.addHeader(AUTH, TokenHandler.getToken());
        return chain.proceed(requestBuilder.build());
    }
}
