package cn.quantgroup.tech.shutdown;

import cn.quantgroup.tech.shutdown.properties.GracefulShutdownProperties;
import cn.quantgroup.tech.shutdown.service.Shutdown;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationContext;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/**
 * 默认的停止信号接收处理.
 *
 * @author ag
 */
@Slf4j
public class DefaultSignalHandler implements SignalHandler {

    private ApplicationContext context;

    public DefaultSignalHandler(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void handle(Signal signal) {
        try {
            String applicationName = context.getApplicationName();
            log.info("开始执行停止{}服务", applicationName);
            GracefulShutdownProperties bean = context.getBean(GracefulShutdownProperties.class);
            String shutdownBeanName = null;
            try {
                String[] shutdownBeanNames = context.getBeanNamesForType(Shutdown.class);
                shutdownBeanName = shutdownBeanNames[0];
                //如果不是web应用. 这里会找不到shutdown bean
                context.getBean(shutdownBeanName, Shutdown.class).shutdown(bean.getTimeout());
                log.info("{} 停止接收请求", shutdownBeanName);
            } catch (Exception e) {
                log.info("{} shutdown 失败", shutdownBeanName);
            }
            log.info("{} 即将执行 @PreDestroy 方法", applicationName);
            System.exit(0);
            //处理无法exit(0)的动作
            Thread.getAllStackTraces().forEach((thread, stackTraceElements) -> {
                if (!thread.isDaemon()) {
                    //如果中断 daemon 线程, 会导致 PreDestroy 方法不执行,
                    //如果不中断 non-daemon 线程, 会导致无法 exit(0).
                    log.debug("中断正在进行的 non-daemon 线程: {} ; {}", thread.getId(), thread.getName());
                    thread.interrupt();
                }
            });
            System.exit(0);
        } catch (Exception e) {
            // 此处可能导致异常的里面包含了logback中类未能找到, 所以增加输出到控制台.
            System.out.println(e.getMessage());
            log.error(e.getMessage(), e);
        } finally {
            System.out.println("强制退出.");
            System.exit(1);
        }
    }
}
