package cn.quantgroup.tech.brave.interceptor;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


@Slf4j
public abstract class RequestInterceptor {
    protected static final String AUTH = "quant-auth";

    List<String> authHttpList;

    // 内网
    @Value("#{'${tech.auth.http}'.split(',')}")
    public void setAuthHttpList(List<String> authHttpList) {
        this.authHttpList = authHttpList.stream()
                .map(RequestInterceptor::apply)
                .filter(Optional::isPresent)
                .map(Optional::get)
                .map(URL::getHost)
                .collect(Collectors.toList());
    }

    /**
     * *.xyqb.com *.q-gp.com *.quantgroup.cn
     *
     * @param host
     * @return
     */
    protected boolean auth(String host) {
        if (authHttpList == null || authHttpList.isEmpty()) {
            return false;
        }
        return authHttpList.stream().map(authHttp -> authHttp.replace("*", "")).anyMatch(host::endsWith);
    }

    private static Optional<URL> apply(String http) {
        URL url = null;
        try {
            url = new URL(http);
        } catch (MalformedURLException e) {
            log.error("无效tech.auth.http = 【{}】", http);
        }
        return Optional.ofNullable(url);
    }
}
