package cn.quantgroup.boot.tech.brave.service;

import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
public interface ITechRabbitBuilder {

    /**
     * 构建RabbitTemplate
     * @param connectionFactory
     * @returne
     */
    RabbitTemplate createRabbitTemplate(ConnectionFactory connectionFactory);

    /**
     * 构建SimpleRabbitListenerContainerFactory
     * @param connectionFactory
     * @return
     */
    SimpleRabbitListenerContainerFactory createSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory);
}
