package cn.quantgroup.tech.brave.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * brave配置信息
 *
 * @author zhangheng
 * create on 2018.04.25
 */
@Data
@ConfigurationProperties( prefix = "tech.brave" )
public class BraveProperties {
    /**
     * 指定serviceName
     */
    private String serviceName;

    /**
     * kafka地址
     */
    private String kafkaHost;

    /**
     * kafka的topic
     */
    private String kafkaTopic;

    /**
     * 采集率
     */
    private Float sample = 1.0f;
}

