package cn.quantgroup.boot.micrometer.register.kafka;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Influxdb line protocol special characters.
 */
public enum CharacterEnum {
  Comma(",", Arrays.asList(ElementEnum.Measurement, ElementEnum.FieldKey, ElementEnum.TagKey,
      ElementEnum.TagValue), "\\,"),
  Space(" ", Arrays.asList(ElementEnum.Measurement, ElementEnum.FieldKey, ElementEnum.TagKey,
      ElementEnum.TagValue), "\\ "),
  EqualsSign("=", Arrays.asList(ElementEnum.FieldKey, ElementEnum.TagKey, ElementEnum.TagValue),
      "\\="),
  DoubleQuote("\"", Collections.singletonList(ElementEnum.FieldValue), "\\\""),
  BackSlash("\\", Collections.singletonList(ElementEnum.FieldValue), "\\\\");

  CharacterEnum(String value, List<ElementEnum> element, String elapsedValue) {
    this.value = value;
    this.element = element;
    this.elapsedValue = elapsedValue;
  }

  //Escape characters
  private final String value;
  //Element
  private final List<ElementEnum> element;
  //Escaped characters
  private final String elapsedValue;

  public String getValue() {
    return value;
  }

  public List<ElementEnum> getElement() {
    return element;
  }

  public String getElapsedValue() {
    return elapsedValue;
  }
}
