package cn.quantgroup.boot.tech.brave.configuration;

import cn.quantgroup.boot.tech.brave.interceptor.HttpClientRequestInterceptor;
import cn.quantgroup.boot.tech.brave.interceptor.OkHttpClientInterceptor;
import cn.quantgroup.boot.tech.brave.interceptor.RestTemplateRequestInterceptor;
import cn.quantgroup.boot.tech.brave.interceptor.impl.*;
import okhttp3.Interceptor;
import org.apache.http.HttpRequestInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;

@Configuration
public class AuthAutoConfiguration {

    @Configuration
    public static class NoAuthConfiguration {

        @Configuration
        @ConditionalOnClass(HttpRequestInterceptor.class)
        @ConditionalOnMissingBean(HttpClientRequestInterceptor.class)
        public static class HttpRequestInterceptorEnable {

            @Bean
            public HttpClientRequestInterceptor httpClientRequestInterceptor() {
                return new HttpClientNoAuthRequestInterceptor();
            }
        }

        @Configuration
        @ConditionalOnClass(Interceptor.class)
        @ConditionalOnMissingBean(OkHttpClientInterceptor.class)
        public static class InterceptorEnable {

            @Bean
            public OkHttpClientInterceptor okHttpClientInterceptor() {
                return new OkHttpClientNoAuthInterceptor();
            }
        }

        @Configuration
        @ConditionalOnClass(ClientHttpRequestInterceptor.class)
        @ConditionalOnMissingBean(RestTemplateRequestInterceptor.class)
        public static class ClientHttpRequestInterceptorEnable {

            @Bean
            public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
                return new RestTemplateNoAuthRequestInterceptor();
            }
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix = "tech.auth", name = "enabled", havingValue = "true")
    public static class AuthConfiguration {

        @Configuration
        @ConditionalOnClass(HttpRequestInterceptor.class)
        @ConditionalOnProperty(prefix = "tech.auth", name = {"http", "clientId", "secret", "tokenUrl"})
        public static class HttpRequestInterceptorEnable {

            @Bean
            public HttpClientRequestInterceptor httpClientRequestInterceptor() {
                return new HttpClientAuthRequestInterceptor();
            }
        }

        @Configuration
        @ConditionalOnClass(Interceptor.class)
        @ConditionalOnProperty(prefix = "tech.auth", name = {"http", "clientId", "secret", "tokenUrl"})
        public static class InterceptorEnable {

            @Bean
            public OkHttpClientInterceptor okHttpClientInterceptor() {
                return new OkHttpClientAuthInterceptor();
            }
        }

        @Configuration
        @ConditionalOnClass(ClientHttpRequestInterceptor.class)
        @ConditionalOnProperty(prefix = "tech.auth", name = {"http", "clientId", "secret", "tokenUrl"})
        public static class ClientHttpRequestInterceptorEnable {

            @Bean
            public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
                return new RestTemplateAuthRequestInterceptor();
            }
        }
    }
}
