package cn.quantgroup.tech.sentry;

import cn.quantgroup.tech.util.TechEnvironment;
import io.sentry.Sentry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;

import javax.annotation.PostConstruct;

@Configuration
@ConditionalOnProperty(name = "dsn")
public class SentryConfig {

    @Value("${dsn}")
    private String dsn;

    @Bean
    public HandlerExceptionResolver sentryExceptionResolver() {
        return new CustomSentryExceptionResolver();
    }

    @Bean
    public ServletContextInitializer sentryServletContextInitializer() {
        return new io.sentry.spring.SentryServletContextInitializer();
    }

    @PostConstruct
    public void initSentry() {
        if (TechEnvironment.isPro()) {
            Sentry.init(dsn);
        }
    }
}
