package cn.quantgroup.tech.shutdown;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.config.RabbitListenerConfigUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PreDestroy;

/**
 * 这里是一些基本的停止工具.  to be continue
 *
 * @author ag
 */
@Slf4j
@Component
public class BaseDestroyHandler {

    @Autowired
    private ApplicationContext applicationContext;

    @PreDestroy
    @ConditionalOnBean(RedisTemplate.class)
    private void stopRedisSub() {
        log.info("我什么都没做, redis stopped");
    }

    @PreDestroy
    @ConditionalOnBean(RabbitTemplate.class)
    private void stopRabbitMQ() {
        try {
            RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry = applicationContext.getBean(
                    RabbitListenerConfigUtils.RABBIT_LISTENER_ENDPOINT_REGISTRY_BEAN_NAME,
                    RabbitListenerEndpointRegistry.class);
            rabbitListenerEndpointRegistry.getListenerContainers().forEach(Lifecycle::stop);
        } catch (Exception e) {
            log.error("貌似停止 MQ 遇到了问题...");
        }
        log.info("MQ listener stopped");
    }
}
