package cn.quantgroup.tech.elastic.job.lite.listener;

import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.MDC;

/**
 * Created by Baiye on 2020-06-09.
 *
 * @author Baiye
 */
public class AddTraceListener implements ElasticJobListener {

    private final static String PLACEHOLDER = "X-B3-TraceId";

    @Override
    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        MDC.put(PLACEHOLDER, RandomStringUtils.randomAlphabetic(10));
    }

    @Override
    public void afterJobExecuted(ShardingContexts shardingContexts) {
        MDC.remove(PLACEHOLDER);
    }
}
