package cn.quantgroup.tech.brave.service.impl;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.okhttp3.TracingInterceptor;
import cn.quantgroup.tech.brave.service.ITechOkHttpClient;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

/**
 * @author zhangheng
 * create on 2018.05.17
 */
@Slf4j
public class TechOkHttpClientTrace implements ITechOkHttpClient{
    private Tracing tracing;

    public TechOkHttpClientTrace(Tracing tracing) {
        this.tracing = tracing;
    }

    @Override
    public OkHttpClient.Builder createOkHttpClientBuilder() {
        log.info("构建brave-OkHttpClient.Builder");
        HttpTracing httpTracing = HttpTracing.create(tracing);
        return new OkHttpClient.Builder()
                .dispatcher(new Dispatcher(httpTracing.tracing().currentTraceContext().executorService(new Dispatcher().executorService())))
                .addNetworkInterceptor(TracingInterceptor.create(httpTracing));
    }
}
