package cn.quantgroup.tech.brave.job;

import cn.quantgroup.tech.brave.handler.TokenHandler;
import cn.quantgroup.tech.brave.service.ITechRestTemplateBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Base64;
import java.util.Map;

@Data
class TokenResp {
    private Integer code;
    @JsonProperty("access_token")
    private String token;
    @JsonProperty("expires_in")
    private Integer expires;
}

@Slf4j
@EnableScheduling
public class TokenJob {

    private static final String CREDENTIAL = "credential";
    private static final int SUCCESS = 200;

    @Value("${quant.auth.clientId}")
    private String clientId;
    @Value("${quant.auth.secret}")
    private String secret;
    @Value("${quant.auth.tokenUrl}")
    private String tokenUrl;

    @Resource
    private ITechRestTemplateBuilder techRestTemplateBuilder;

    @Bean
    public RestTemplate restTemplate() {
        return techRestTemplateBuilder.createRestTemplate();
    }

    @Scheduled(cron = "0 */30 * * * ?")
    public void getToken() {
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add(CREDENTIAL, base64ForCredential());
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(requestHeaders);
        TokenResp tokenResp = restTemplate().postForObject(tokenUrl, httpEntity, TokenResp.class);
        log.info("getToken tokenResp = 【{}】", tokenResp);
        boolean tokenValid = tokenResp != null && SUCCESS == tokenResp.getCode() && StringUtils.isNotBlank(tokenResp.getToken());
        if (tokenValid) {
            TokenHandler.setToken(tokenResp.getToken());
        }
    }


    @Scheduled(cron = "0 */2 * * * ?")
    public void getTokenDemotion() {
        if (StringUtils.isBlank(TokenHandler.getToken())) {
            getToken();
        }
    }

    private String base64ForCredential() {
        String credential = clientId + ":" + secret;
        return Base64.getEncoder().encodeToString(credential.getBytes());
    }

    @PostConstruct
    public void init() {
        getToken();
    }
}
