package cn.quantgroup.boot.tech.generator.configuration;


import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

/**
 * 只要有 redis 就可以使用id generator
 *
 * @author zhiguo.liu
 */
@ConditionalOnClass(RedisTemplate.class)
@EnableConfigurationProperties(GeneratorAutoConfiguration.IdGeneratorProperties.class)
public class GeneratorAutoConfiguration {

    private StringRedisTemplate redisTemplate;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        redisTemplate = applicationContext.getBean(StringRedisTemplate.class);
    }


    @Bean
    public GeneratorFactoryBean generatorFactoryBean(IdGeneratorProperties properties) {
        return GeneratorFactoryBean.builder()
                .dataCenterId(properties.getDataCenter())
                .dataCenterIdBits(properties.getDataCenterIdBits())
                .epochStr(properties.getEpochStr())
                .seqBits(properties.getSeqBits())
                .workerBits(properties.getWorkerBits())
                .stringRedisTemplate(redisTemplate)
                .build();
    }


    @Data
    @ConfigurationProperties(prefix = "tech.id")
    protected static class IdGeneratorProperties {
        /**
         * 这里每个服务都需要单独配置一个
         */
        private int dataCenter = 1;
        /**
         * 下面每一个配置,如果不懂就不建议修改.
         * dataCenterIdBits 1024个服务
         */
        private int dataCenterIdBits = 10;
        private int seqBits = 13;
        private int workerBits = 8;
        private String epochStr = "2018-04-01";

    }
}
