package cn.quantgroup.tech.shutdown;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.config.RabbitListenerConfigUtils;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.stereotype.Component;

import javax.annotation.PreDestroy;

@Slf4j
@Component
public class BaseDestroyHandler {

    @Autowired
    private ApplicationContext applicationContext;

    @PreDestroy
    private void stopRedisSub() {
//        context.getBean(RedisMessageListenerContainer.)
        log.info("redis stopped");
    }

    @PreDestroy
    private void stopRabbitMQ() {
        RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry = applicationContext.getBean(
                RabbitListenerConfigUtils.RABBIT_LISTENER_ENDPOINT_REGISTRY_BEAN_NAME,
                RabbitListenerEndpointRegistry.class);
        rabbitListenerEndpointRegistry.getListenerContainers().forEach(Lifecycle::stop);
        log.info("MQ listener stopped");
    }
}
