package cn.quantgroup.tech.brave.service;

import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
public interface ITechRabbitBuilder {
    /**
     * 设定Mq的名称
     * @param remoteServiceName
     * @return
     */
    ITechRabbitBuilder remoteServiceName(String remoteServiceName);

    /**
     * 构建RabbitTemplate
     * @param connectionFactory
     * @return
     */
    RabbitTemplate crateRabbitTemplate(ConnectionFactory connectionFactory);

    /**
     * 构建SimpleRabbitListenerContainerFactory
     * @param connectionFactory
     * @return
     */
    SimpleRabbitListenerContainerFactory createSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory);
}
