package cn.quantgroup.tech.mq.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 考拉消息补偿表
 * </p>
 *
 * @author rui
 * @since 2020-04-28
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class KoalaRabbitmqMessage implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 消息唯一id
     */
    private String uniqueId;

    /**
     * 消息内容
     */
    private String msgContent;

    /**
     * 消息状态 0未发送 1已发送 2失败（发送三次仍未ack则失败）
     */
    private Integer msgStatus;

    /**
     * 交换机名称
     */
    private String exchange;

    /**
     * 路由键
     */
    private String routingKey;

    /**
     * 重试次数
     */
    private Integer retryCount;

    /**
     * 消费次数
     */
    private Integer consumeCount;

    /**
     * 最大消费次数
     */
    private Integer maxConsumeCount;

    /**
     * 业务类型
     */
    private Integer middleBusinessType;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;
}
