package cn.quantgroup.tech.mq.aop;

import cn.quantgroup.tech.mq.common.Constants;
import cn.quantgroup.tech.mq.entity.KoalaRabbitmqMessage;
import cn.quantgroup.tech.mq.mapper.KoalaRabbitmqMessageMapperV1;
import com.rabbitmq.client.Channel;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;

@Aspect
@Component
public class RabbitListenerAspect {

    @Resource
    private RabbitTemplate moNotifyRabbitTemplate;
    @Resource
    private KoalaRabbitmqMessageMapperV1 koalaRabbitmqMessageMapperV1;

    /**
     * arg[0] message
     * arg[1] channel
     * arg[2] deliveryTag
     * arg[3] correlationId -> unique_id
     * arg[4] scenario -> 场景
     *
     * @param joinPoint
     * @return
     */
    @Around("@annotation(org.springframework.amqp.rabbit.annotation.RabbitListener)")
    public void aroundAdvice(ProceedingJoinPoint joinPoint) throws IOException {
        Object rtValue = null;
        Object obj = joinPoint.getArgs()[0];
        Channel channel = (Channel) joinPoint.getArgs()[1];
        Long deliveryTag = (Long) joinPoint.getArgs()[2];
        String uniqueId = (String) joinPoint.getArgs()[3];
        String scenario = (String) joinPoint.getArgs()[4];
        koalaRabbitmqMessageMapperV1.addConsumeCountByUniqueId(uniqueId);
        try {
            rtValue = joinPoint.proceed();
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (scenario.equals("GRADIENT_NOTICE")) {
            if ("success".equals(rtValue)) {
                channel.basicAck(deliveryTag, false);
            } else {
                KoalaRabbitmqMessage koalaRabbitmqMessage = koalaRabbitmqMessageMapperV1.selectByUniqueId(uniqueId);
                CorrelationData correlationData = new CorrelationData(uniqueId);
                moNotifyRabbitTemplate.convertAndSend(Constants.MO_TTL_EXCHANGE, koalaRabbitmqMessage.getRoutingKey(), obj, correlationData);
                channel.basicNack(deliveryTag, false, false);
            }
        } else {
            channel.basicAck(deliveryTag, false);
        }
    }
}
