package cn.quantgroup.tech.shutdown.service;

import cn.quantgroup.tech.shutdown.wrapper.UndertowShutdownHandlerWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Undertow shutdown.
 */
@Slf4j
public class UndertowShutdown implements Shutdown {

    /**
     * The wrapper for manual commands.
     */
    @Autowired
    private UndertowShutdownHandlerWrapper undertowShutdownHandlerWrapper;

    /**
     * Perform shutdown.
     *
     * @param delay is delay to force
     * @throw InterruptedException if we have an interruption
     */
    @Override
    public void shutdown(Integer delay) throws InterruptedException {
        undertowShutdownHandlerWrapper.getGracefulShutdownHandler().shutdown();
        undertowShutdownHandlerWrapper.getGracefulShutdownHandler().awaitShutdown(delay * 1000);
    }
}
