package cn.quantgroup.boot;


import com.alibaba.cloud.nacos.registry.NacosAutoServiceRegistration;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.boot.actuate.context.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;

@WebEndpoint(id = "serviceDeploy")
public class ServiceDeployEndpoint {

  final NacosAutoServiceRegistration nacosAutoServiceRegistration;
  final ShutdownEndpoint shutdownEndpoint;

  public ServiceDeployEndpoint(NacosAutoServiceRegistration nacosAutoServiceRegistration,
      ShutdownEndpoint shutdownEndpoint) {
    this.nacosAutoServiceRegistration = nacosAutoServiceRegistration;
    this.shutdownEndpoint = shutdownEndpoint;
  }

  @ReadOperation
  public String offLine() {
    nacosAutoServiceRegistration.stop();
    new Timer().schedule(new TimerTask(
    ) {
      @Override
      public void run() {
        shutdownEndpoint.shutdown();
      }
    }, 4000L);
    return "ok";
  }

  @WriteOperation
  public String onLine() {
    nacosAutoServiceRegistration.start();
    return "ok";
  }
}