package cn.quantgroup.tech.brave.interceptor;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Optional;


@Slf4j
public abstract class RequestInterceptor {
//    @Data
//    static class AuthInfoInMemory {
//        private static boolean auth;
//        private static long expiration;
//    }

    protected static final String AUTH = "quant-auth";
    // 内网
    @Value("#{'${quant.auth.http}'.split(',')}")
    List<String> authHttpList;

    protected boolean auth(String host) {
//        if (authCache()) return true;
        if (authHttpList == null || authHttpList.isEmpty()) {
            return false;
        }
        boolean auth = authHttpList.stream()
                .map(http -> {
                    URL url = null;
                    try {
                        url = new URL(http);
                    } catch (MalformedURLException e) {
                        log.error("无效quant.auth.http = 【{}】", http);
                    }
                    return Optional.ofNullable(url);
                })
                .filter(Optional::isPresent)
                .anyMatch(url -> url.get().getHost().equals(host));
//        buildAuthCache(auth);
        return auth;
    }

//    private boolean authCache() {
//        return AuthInfoInMemory.auth && System.currentTimeMillis() < AuthInfoInMemory.expiration;
//    }
//
//    private void buildAuthCache(boolean auth) {
//        AuthInfoInMemory.auth = auth;
//        AuthInfoInMemory.expiration = System.currentTimeMillis() + 10 * 60 * 60;
//    }
}
