package cn.quantgroup.tech.brave.configuration;

import cn.quantgroup.tech.brave.interceptor.*;
import cn.quantgroup.tech.brave.interceptor.impl.HttpClientAuthRequestInterceptor;
import cn.quantgroup.tech.brave.interceptor.impl.HttpClientNoAuthRequestInterceptor;
import cn.quantgroup.tech.brave.interceptor.impl.RestTemplateAuthRequestInterceptor;
import cn.quantgroup.tech.brave.interceptor.impl.RestTemplateNoAuthRequestInterceptor;
import cn.quantgroup.tech.brave.job.TokenJob;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthAutoConfiguration {

    @Configuration
    public static class NoAuthConfiguration {

        @Bean
        @ConditionalOnMissingBean(HttpClientRequestInterceptor.class)
        public HttpClientRequestInterceptor httpClientRequestInterceptor() {
            return new HttpClientNoAuthRequestInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(RestTemplateRequestInterceptor.class)
        public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
            return new RestTemplateNoAuthRequestInterceptor();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix = "quant.auth", name = {"http", "clientId", "secret", "tokenUrl"})
    public static class AuthConfiguration {

        @Bean
        public HttpClientRequestInterceptor httpClientRequestInterceptor() {
            return new HttpClientAuthRequestInterceptor();
        }

        @Bean
        public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
            return new RestTemplateAuthRequestInterceptor();
        }

        @Bean
        public TokenJob tokenJob() {
            return new TokenJob();
        }
    }
}
